/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MosPUserDto;
import jp.mosp.common.vo.MosPVo;

public class AccountMasterCardVo extends MosPVo {

	private static final long serialVersionUID = 621967770700551876L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/system/accountMasterCard.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/accountMasterCard.js";
	private static final String EXTRA_CSS  = "/pub/system/css/accountMasterCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_ACCOUNT_MASTER;

	// 萔
	public static final int MODE_INSERT = 0;
	public static final int MODE_UPDATE = 1;
	public static final int MODE_SYSTEM = 2;	

	// p[^
	public static final String PRM_TXT_USER_ID    = "txtUserId";
	public static final String PRM_TXT_K_CODE     = "txtKCode";
	public static final String PRM_TXT_USER_NAME  = "txtUserName";
	public static final String PRM_PLT_AUTHORITY  = "pltAuthority";
	public static final String PRM_TXT_DATA_LEVEL = "txtDataLevel";
	public static final String PRM_PLT_DELETE     = "pltDelete";

	// tB[h
	private String txtUserId;
	private String txtKCode;
	private String txtUserName;
	private String pltAuthority;
	private String txtDataLevel;
	private String pltDelete;

	// v_EXg
	public String[][] aryPltAuthority;

	// [h(0FVKo^A1FXV)
	private int mode;

	// tB[hyѐ
	public static final String NAM_USER_ID    = CommonConst.NAM_USER_ID;
	public static final String NAM_K_CODE     = CommonConst.NAM_K_CODE;
	public static final String NAM_USER_NAME  = CommonConst.NAM_USER_NAME;
	public static final String NAM_AUTHORITY  = CommonConst.NAM_AUTHORITY;
	public static final String NAM_DATA_LEVEL = CommonConst.NAM_DATA_LEVEL;
	public static final String NAM_DELETE     = CommonConst.NAM_DELETE_FLAG;

	public static final int    LEN_USER_ID    = 10;
	public static final int    LEN_K_CODE     = CommonConst.LEN_K_CODE;
	public static final int    LEN_USER_NAME  = 16;
	public static final int    LEN_AUTHORITY  = 2;
	public static final int    LEN_DATA_LEVEL = 2;
	public static final String REG_DELETE     = CommonConst.REG_DELETE;

	/**
	 * RXgN^
	 */
	public AccountMasterCardVo() {
		super();
		mode = 0;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		setTxtUserId("");
		setTxtUserName("");
		setPltAuthority("");
		setTxtDataLevel("");
		setPltDelete("");
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		txtUserId    = request.getParameter(PRM_TXT_USER_ID);
		txtKCode     = request.getParameter(PRM_TXT_K_CODE);
		txtUserName  = request.getParameter(PRM_TXT_USER_NAME);
		pltAuthority = request.getParameter(PRM_PLT_AUTHORITY);
		txtDataLevel = request.getParameter(PRM_TXT_DATA_LEVEL);
		pltDelete    = request.getParameter(PRM_PLT_DELETE);
	}

	/**
	 * tB[hݒ
	 * @param dto [U[Xg
	 */
	public void setFields(MosPUserDto dto) {
		// f[^̐ݒ
		txtUserId    = dto.getUserId();
		txtKCode     = dto.getKCode();
		txtUserName  = dto.getUserName();
		pltAuthority = dto.getAuthority();
		txtDataLevel = String.valueOf(dto.getDataLevel());
		pltDelete    = String.valueOf(dto.getDeleteFlag());
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtUserId   , NAM_USER_ID   , PRM_TXT_USER_ID   );
		checkRequired(txtUserName , NAM_USER_NAME , PRM_TXT_USER_NAME );
		checkRequired(pltAuthority, NAM_AUTHORITY , PRM_PLT_AUTHORITY );
		checkRequired(txtDataLevel, NAM_DATA_LEVEL, PRM_TXT_DATA_LEVEL);
		checkRequired(pltDelete   , NAM_DELETE    , PRM_PLT_DELETE    );
		// ^CvmF
		checkCode    (txtUserId   , NAM_USER_ID   , PRM_TXT_USER_ID   );
		checkCode    (txtKCode    , NAM_K_CODE    , PRM_TXT_K_CODE    );
		checkCode    (pltAuthority, NAM_AUTHORITY , PRM_PLT_AUTHORITY );
		checkNumber  (txtDataLevel, NAM_DATA_LEVEL, PRM_TXT_DATA_LEVEL);
		checkRegex   (pltDelete, REG_DELETE, NAM_DELETE, PRM_PLT_DELETE);
		// 񒷊mF
		checkLength  (txtUserId   , LEN_USER_ID   , NAM_USER_ID   , PRM_TXT_USER_ID   );
		checkLength  (txtKCode    , LEN_K_CODE    , NAM_K_CODE    , PRM_TXT_K_CODE    );
		checkLength  (txtUserName , LEN_USER_NAME , NAM_USER_NAME , PRM_TXT_USER_NAME );
		checkLength  (pltAuthority, LEN_AUTHORITY , NAM_AUTHORITY , PRM_PLT_AUTHORITY );
		checkLength  (txtDataLevel, LEN_DATA_LEVEL, NAM_DATA_LEVEL, PRM_TXT_DATA_LEVEL);
		// ÓmFI
		endValidation();
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MosPUserDto dto) {
		dto.setUserId(txtUserId);
		dto.setKCode(txtKCode);
		dto.setUserName(txtUserName);
		dto.setAuthority(pltAuthority);
		dto.setDataLevel(Integer.parseInt(txtDataLevel));
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("mode = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public void setTxtUserId		(String txtUserId	) 	{ this.txtUserId 		= txtUserId		; }
	public void setTxtKCode		(String txtKCode	) 	{ this.txtKCode 		= txtKCode		; }
	public void setTxtUserName		(String txtUserName	) 	{ this.txtUserName 		= txtUserName	; }
	public void setPltAuthority	(String pltAuthority) 	{ this.pltAuthority 	= pltAuthority	; }
	public void setTxtDataLevel	(String txtDataLevel) 	{ this.txtDataLevel 	= txtDataLevel	; }
	public void setPltDelete		(String pltDelete	) 	{ this.pltDelete 		= pltDelete		; }

	public String getTxtUserId() 		{ return txtUserId		; }
	public String getTxtKCode() 		{ return txtKCode		; }
	public String getTxtUserName() 		{ return txtUserName	; }
	public String getPltAuthority() 	{ return pltAuthority	; }
	public String getTxtDataLevel() 	{ return txtDataLevel	; }
	public String getPltDelete() 		{ return pltDelete		; }

	public String getEscTxtUserId() 	{ return escapeHTML(txtUserId)		; }
	public String getEscTxtKCode() 		{ return escapeHTML(txtKCode)		; }
	public String getEscTxtUserName() 	{ return escapeHTML(txtUserName)	; }
	public String getEscTxtDataLevel() 	{ return escapeHTML(txtDataLevel)	; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
